
import tqdm

from src.exports.export_profile import export_profile, export_points
from src.sampling.euclidean_sampler import euclidean_1d_profile



if __name__ == "__main__":

    num_tests = 100
    num_voters = 100
    num_candidates = 100

    pairs = [(0.1, 0.1), (0.015, 0.15)]

    for lower_radius, upper_radius in pairs:
        for t in tqdm.tqdm(range(num_tests)):

            sampler = euclidean_1d_profile

            P, v_points, c_points, c_radius = sampler(num_voters=num_voters,
                                            num_candidates=num_candidates,
                                            lower_radius=lower_radius,
                                            upper_radius=upper_radius
                                            )

            profile_path = f'data/sampled/euclidean/profile_{num_voters}_{num_candidates}_{t}_{lower_radius}_{upper_radius}'
            export_profile(P, profile_path)

            v_points_path = f'data/sampled/euclidean/v_points_{num_voters}_{num_candidates}_{t}_{lower_radius}_{upper_radius}.csv'
            export_points(v_points, v_points_path)

            c_points_path = f'data/sampled/euclidean/c_points_{num_voters}_{num_candidates}_{t}_{lower_radius}_{upper_radius}.csv'
            export_points(c_points, c_points_path)



